
`Light Shadow data
type Lighting_LightShadowData
   Light as integer
   Face1Update as integer
   Face2Update as integer
   Face3Update as integer
   Face4Update as integer
   Face5Update as integer
   Face6Update as integer
endtype

`--------------
` Update Shadow Maps
`--------------
function ShadowMapUpdate(iTimer as float)

   `Hide Objects / Cull mode
      for o=0 to Lighting_ObjectsActiveShadowNullCount
         tObject=Lighting_ObjectsActiveShadowNull[o]-1 : SetObjectVisible(Lighting_Objects[tObject].Object,0)
      next o
      for o=0 to Lighting_ObjectsActiveShadowCullCount
         tObject=Lighting_ObjectsActiveShadowCull[o]-1 : SetObjectCullMode(Lighting_Objects[tObject].Object,0)
      next o

   `Render Directional Shadowmap Depths
      if Lighting_LightDirectionColor.x>0 or Lighting_LightDirectionColor.y>0 or Lighting_LightDirectionColor.z>0
         ShadowMapRenderDirectional(1)
         if Lighting_ShadowUpdate[1]<4 and Lighting_ShadowUpdate[2]<8 then ShadowMapRenderDirectional(2)
         if Lighting_ShadowUpdate[1]=4 
            ShadowMapRenderDirectional(3)
            Lighting_ShadowUpdate[1]=0
         endif
         if Lighting_ShadowUpdate[2]>7 and Lighting_ShadowUpdate[1]>0
            ShadowMapRenderDirectional(4)
            Lighting_ShadowUpdate[2]=0
         endif
         inc Lighting_ShadowUpdate[1]
         inc Lighting_ShadowUpdate[2]
      endif

   `Use The Four Nearest Lights For Higher Resolution Shadows
      for x=1 to 4
         Lighting_ShadowPointUse[x]=0 : Lighting_ShadowSpotUse[x]=0
      next x
      for f=1 to 4
         Lighting_ShadowPointNear[f]=-1
         Lighting_ShadowSpotNear[f]=-1
         tNearPoint=-1:tNearPointDist=99999999
         tNearSpot=-1:tNearSpotDist=99999999
         for x=1 to Lighting_MaxShadows
            if Lighting_ShadowPointLight[x]>0
               tLight=Lighting_ShadowPointLight[x]-1
               if Lighting_Lights[tLight].ShadowNear=0 and Lighting_Lights[tLight].Dist/(1+(Lighting_Lights[tLight].Offset.w*0.01))<tNearPointDist 
                  tNearPoint=tLight
                  tNearPointDist=Lighting_Lights[tLight].Dist/(1+(Lighting_Lights[tLight].Offset.w*0.01))
               endif
            endif
            if Lighting_ShadowSpotLight[x]>0
               tLight=Lighting_ShadowSpotLight[x]-1
               if Lighting_Lights[tLight].ShadowNear=0 and Lighting_Lights[tLight].Dist/(1+(Lighting_Lights[tLight].Offset.w*0.01))<tNearSpotDist 
                  tNearSpot=tLight
                  tNearSpotDist=Lighting_Lights[tLight].Dist/(1+(Lighting_Lights[tLight].Offset.w*0.01))
               endif
            endif
         next x
         if tNearPoint>-1 
            Lighting_ShadowPointNear[f]=tNearPoint
            Lighting_Lights[tNearPoint].ShadowNear=1
         endif
         if tNearSpot>-1 
            Lighting_ShadowSpotNear[f]=tNearSpot
            Lighting_Lights[tNearSpot].ShadowNear=1
         endif
         for x=1 to 4
            if Lighting_ShadowPointLight[x]>0
               if Lighting_ShadowPointNear[f]=Lighting_ShadowPointLight[x]-1 then Lighting_ShadowPointUse[x]=1
            endif
            if Lighting_ShadowSpotLight[x]>0
               if Lighting_ShadowSpotNear[f]=Lighting_ShadowSpotLight[x]-1 then Lighting_ShadowSpotUse[x]=1
            endif
         next x
      next f
      for f=1 to 4
         if Lighting_ShadowPointNear[f]>-1
            tLightA=Lighting_ShadowPointNear[f]
            tShadowA=Lighting_Lights[tLightA].ShadowPoint-1
            if tShadowA>4
               for x=1 to 4
                  if Lighting_ShadowPointUse[x]=0
                     Lighting_ShadowPointUse[1]=1:Lighting_ShadowPointUse[2]=1
                     Lighting_ShadowPointUse[3]=1:Lighting_ShadowPointUse[4]=1
                     tLightB=Lighting_ShadowPointLight[x]-1
                     if tLightB>-1
                        Lighting_ShadowPointLight[tShadowA]=tLightB+1
                        Lighting_Lights[tLightB].ShadowPoint=tShadowA+1
                        LightUpdate(tLightB)
                        Lighting_Lights[tLightB].ShadowUpdate=1
                     else
                        Lighting_ShadowPointLight[tShadowA]=0
                     endif
                     Lighting_ShadowPointLight[x]=tLightA+1
                     Lighting_Lights[tLightA].ShadowPoint=x+1
                     LightUpdate(tLightA)
                     Lighting_Lights[tLightA].ShadowUpdate=1
                  endif
               next x
            endif
         endif
         if Lighting_ShadowSpotNear[f]>-1
            tLightA=Lighting_ShadowSpotNear[f]
            tShadowA=Lighting_Lights[tLightA].ShadowSpot-1
            if tShadowA>4
               for x=1 to 4
                  if Lighting_ShadowSpotUse[x]=0
                     Lighting_ShadowSpotUse[1]=1:Lighting_ShadowSpotUse[2]=1
                     Lighting_ShadowSpotUse[3]=1:Lighting_ShadowSpotUse[4]=1
                     tLightB=Lighting_ShadowSpotLight[x]-1
                     if tLightB>-1
                        Lighting_ShadowSpotLight[tShadowA]=tLightB+1
                        Lighting_Lights[tLightB].ShadowSpot=tShadowA+1
                        LightUpdate(tLightB)
                        Lighting_Lights[tLightB].ShadowUpdate=1
                     else
                        Lighting_ShadowSpotLight[tShadowA]=0
                     endif
                     Lighting_ShadowSpotLight[x]=tLightA+1
                     Lighting_Lights[tLightA].ShadowSpot=x+1
                     LightUpdate(tLightA)
                     Lighting_Lights[tLightA].ShadowUpdate=1
                  endif
               next x
            endif
         endif
      next f

   `Render Point/Spot Shadowmap Depths
      for x=1 to Lighting_MaxShadows
         if Lighting_ShadowPointLight[x]>0
            tLight=Lighting_ShadowPointLight[x]-1
            if Lighting_Lights[tLight].ShadowUpdate=1
               Lighting_Lights[tLight].ShadowUpdate=0
               Lighting_Lights[tLight].ShadowUpdateTime=0
               Lighting_ShadowPoint[x].Face1Update=1
               Lighting_ShadowPoint[x].Face2Update=1
               Lighting_ShadowPoint[x].Face3Update=1
               Lighting_ShadowPoint[x].Face4Update=1
               Lighting_ShadowPoint[x].Face5Update=1
               Lighting_ShadowPoint[x].Face6Update=1
            endif
            if Lighting_Lights[tLight].ShadowUpdateTime>0 then dec Lighting_Lights[tLight].ShadowUpdateTime,iTimer*100
            if Lighting_Lights[tLight].InScreen=1 and Lighting_Lights[tLight].ShadowUpdateTime<0.1 then ShadowMapRenderPoint(x,tLight)
         endif
         if Lighting_ShadowSpotLight[x]>0
            tLight=Lighting_ShadowSpotLight[x]-1
            if Lighting_Lights[tLight].ShadowUpdate=1
               Lighting_Lights[tLight].ShadowUpdate=0
               Lighting_Lights[tLight].ShadowUpdateTime=0
               Lighting_ShadowSpot[x].Face1Update=1
            endif
            if Lighting_Lights[tLight].ShadowUpdateTime>0 then dec Lighting_Lights[tLight].ShadowUpdateTime,iTimer*100
            if Lighting_Lights[tLight].InScreen=1 and Lighting_Lights[tLight].ShadowUpdateTime<0.1 then ShadowMapRenderSpot(x,tLight)
         endif
      next x

   `Apply ShadowMap To Light Masks
      for x=1 to Lighting_MaxShadows
         if Lighting_ShadowPointLight[x]>0
            tLight=Lighting_ShadowPointLight[x]-1
            if Lighting_Lights[tLight].PointLight>0
               tPointLight=Lighting_Lights[tLight].PointLight
               if Lighting_PointLights[tPointLight].ShadowMap<>Lighting_ShadowPointImage[x,1]
                  SetObjectImage(Lighting_PointLights[tPointLight].Object,Lighting_ShadowPointImage[x,1],2)
                  SetObjectImage(Lighting_PointLights[tPointLight].Object,Lighting_ShadowPointImage[x,2],3)
                  SetObjectImage(Lighting_PointLights[tPointLight].Object,Lighting_ShadowPointImage[x,3],4)
                  SetObjectImage(Lighting_PointLights[tPointLight].Object,Lighting_ShadowPointImage[x,4],5)
                  SetObjectImage(Lighting_PointLights[tPointLight].Object,Lighting_ShadowPointImage[x,5],6)
                  SetObjectImage(Lighting_PointLights[tPointLight].Object,Lighting_ShadowPointImage[x,6],7)
                  Lighting_PointLights[tPointLight].ShadowMap=Lighting_ShadowPointImage[x,1]
               endif
            endif
         endif
         if Lighting_ShadowSpotLight[x]>0
            tLight=Lighting_ShadowSpotLight[x]-1
            if Lighting_Lights[tLight].SpotLight>0
               tSpotLight=Lighting_Lights[tLight].SpotLight
               if Lighting_SpotLights[tSpotLight].ShadowMap<>Lighting_ShadowSpotImage[x]
                  SetObjectImage(Lighting_SpotLights[tSpotLight].Object,Lighting_ShadowSpotImage[x],2)
                  Lighting_SpotLights[tSpotLight].ShadowMap=Lighting_ShadowSpotImage[x]
               endif
            endif
         endif
      next x

   `Show Objects / Cull mode
      for o=0 to Lighting_ObjectsActiveShadowNullCount
         tObject=Lighting_ObjectsActiveShadowNull[o]-1 : SetObjectVisible(Lighting_Objects[tObject].Object,1)
      next o
      for o=0 to Lighting_ObjectsActiveShadowCullCount
         tObject=Lighting_ObjectsActiveShadowCull[o]-1 : SetObjectCullMode(Lighting_Objects[tObject].Object,1)
      next o

endfunction

`--------------
` Render Directional Light Shadowmap
`--------------
function ShadowMapRenderDirectional(iCascade as integer)
   Range#=Lighting_ShadowRange[iCascade]
   PosX#=Lighting_CameraPosition.x+(Lighting_CameraDir.x*(Range#/2.25))+(Lighting_LightDirection.x*Lighting_ShadowRange[0])
   PosY#=Lighting_CameraPosition.y+(Lighting_CameraDir.y*(Range#/2.25))+(Lighting_LightDirection.y*Lighting_ShadowRange[0])
   PosZ#=Lighting_CameraPosition.z+(Lighting_CameraDir.z*(Range#/2.25))+(Lighting_LightDirection.z*Lighting_ShadowRange[0])
   PosX#=round(PosX#/(Range#*0.1))*(Range#*0.1)
   PosY#=round(PosY#/(Range#*0.1))*(Range#*0.1)
   PosZ#=round(PosZ#/(Range#*0.1))*(Range#*0.1)
   SetCameraRange(1,1,Lighting_ShadowRange[0]*2)
   SetCameraPosition(1,PosX#,PosY#,PosZ#)
   AngX#=asin(Lighting_LightDirection.Y)
   AngY#=atanfull(-Lighting_LightDirection.X,Lighting_LightDirection.Z)
   SetCameraRotation(1,AngX#,AngY#,0)
   SetCameraAspect(1,1)
   SetCameraFov(1,0)
   SetCameraOrthoWidth(1,Range#*0.5)
   SetRenderToImage(0,Lighting_ShadowDirectionalImage[iCascade])
   ClearScreen()
   if iCascade=1
      for o=0 to Lighting_ObjectsActiveShadow1NullCount
         tObject=Lighting_ObjectsActiveShadow1Null[o]-1 : SetObjectVisible(Lighting_Objects[tObject].Object,0)
      next o
   endif
   if iCascade=2
      for o=0 to Lighting_ObjectsActiveShadow2NullCount
         tObject=Lighting_ObjectsActiveShadow2Null[o]-1 : SetObjectVisible(Lighting_Objects[tObject].Object,0)
      next o
   endif
   if iCascade=3
      for o=0 to Lighting_ObjectsActiveShadow3NullCount
         tObject=Lighting_ObjectsActiveShadow3Null[o]-1 : SetObjectVisible(Lighting_Objects[tObject].Object,0)
      next o
   endif
   if iCascade=4
      for o=0 to Lighting_ObjectsActiveShadow4NullCount
         tObject=Lighting_ObjectsActiveShadow4Null[o]-1 : SetObjectVisible(Lighting_Objects[tObject].Object,0)
      next o
   endif
   render3d()
   if iCascade=1
      for o=0 to Lighting_ObjectsActiveShadow1NullCount
         tObject=Lighting_ObjectsActiveShadow1Null[o]-1 : SetObjectVisible(Lighting_Objects[tObject].Object,1)
      next o
   endif
   if iCascade=2
      for o=0 to Lighting_ObjectsActiveShadow2NullCount
         tObject=Lighting_ObjectsActiveShadow2Null[o]-1 : SetObjectVisible(Lighting_Objects[tObject].Object,1)
      next o
   endif
   if iCascade=3
      for o=0 to Lighting_ObjectsActiveShadow3NullCount
         tObject=Lighting_ObjectsActiveShadow3Null[o]-1 : SetObjectVisible(Lighting_Objects[tObject].Object,1)
      next o
   endif
   if iCascade=4
      for o=0 to Lighting_ObjectsActiveShadow4NullCount
         tObject=Lighting_ObjectsActiveShadow4Null[o]-1 : SetObjectVisible(Lighting_Objects[tObject].Object,1)
      next o
   endif
   CX#=Cos(AngX#) : SX#=Sin(AngX#)
   CY#=Cos(AngY#) : SY#=Sin(AngY#)
   Set_Vector3(1,SY#*CX#,(-1.0*SX#),CY#*CX#)
   Set_Vector3(2,SY#*SX#,CX#,CY#*SX#)
   Cross_Product_Vector3(3,2,1)
   Cross_Product_Vector3(4,1,3)
   SetIdentity_Matrix4(1)
   Matrix4Float[1,1].x=Vector3Float[3].x : Matrix4Float[1,1].y=Vector3Float[4].x : Matrix4Float[1,1].z=Vector3Float[1].x
   Matrix4Float[1,2].x=Vector3Float[3].y : Matrix4Float[1,2].y=Vector3Float[4].y : Matrix4Float[1,2].z=Vector3Float[1].y
   Matrix4Float[1,3].x=Vector3Float[3].z : Matrix4Float[1,3].y=Vector3Float[4].z : Matrix4Float[1,3].z=Vector3Float[1].z
   Translate_Matrix4(2,-PosX#,-PosY#,-PosZ#)
   Multiply_Matrix4(1,2,1)
   Fill_Matrix4(2,0.0)
   Matrix4Float[2,1].x=2.0/Range#
   Matrix4Float[2,2].y=2.0/Range#
   Matrix4Float[2,3].z=1.0/((Lighting_ShadowRange[0]*2)-1)
   Matrix4Float[2,4].z=1.0/(1-(Lighting_ShadowRange[0]*2))
   Matrix4Float[2,4].w=1.0
   Multiply_Matrix4(3,1,2)
   tEffect=Lighting_Effect[1]
   SetShaderConstantArrayByName(Effects[tEffect].Shader[Lighting_ShadowsQuality],"ShadowProj"+str(iCascade),0,Matrix4Float[3,1].x,Matrix4Float[3,1].y,Matrix4Float[3,1].z,Matrix4Float[3,1].w)
   SetShaderConstantArrayByName(Effects[tEffect].Shader[Lighting_ShadowsQuality],"ShadowProj"+str(iCascade),1,Matrix4Float[3,2].x,Matrix4Float[3,2].y,Matrix4Float[3,2].z,Matrix4Float[3,2].w)
   SetShaderConstantArrayByName(Effects[tEffect].Shader[Lighting_ShadowsQuality],"ShadowProj"+str(iCascade),2,Matrix4Float[3,3].x,Matrix4Float[3,3].y,Matrix4Float[3,3].z,Matrix4Float[3,3].w)
   SetShaderConstantArrayByName(Effects[tEffect].Shader[Lighting_ShadowsQuality],"ShadowProj"+str(iCascade),3,Matrix4Float[3,4].x,Matrix4Float[3,4].y,Matrix4Float[3,4].z,Matrix4Float[3,4].w)
   if iCascade=3
      for e=0 to Lighting_EffectsCount
         if Lighting_Effects[e].InUse=1 
            tEffect=Lighting_Effects[e].Effect
            if Effects[tEffect].ShaderCount=0
               SetShaderConstantArrayByName(Effects[tEffect].Shader[0],"ShadowsProj",0,Matrix4Float[3,1].x,Matrix4Float[3,1].y,Matrix4Float[3,1].z,Matrix4Float[3,1].w)
               SetShaderConstantArrayByName(Effects[tEffect].Shader[0],"ShadowsProj",1,Matrix4Float[3,2].x,Matrix4Float[3,2].y,Matrix4Float[3,2].z,Matrix4Float[3,2].w)
               SetShaderConstantArrayByName(Effects[tEffect].Shader[0],"ShadowsProj",2,Matrix4Float[3,3].x,Matrix4Float[3,3].y,Matrix4Float[3,3].z,Matrix4Float[3,3].w)
               SetShaderConstantArrayByName(Effects[tEffect].Shader[0],"ShadowsProj",3,Matrix4Float[3,4].x,Matrix4Float[3,4].y,Matrix4Float[3,4].z,Matrix4Float[3,4].w)
            endif
         endif
      next e
   endif
endfunction

`--------------
` Render Point Light Shadowmaps
`--------------
function ShadowMapRenderPoint(iShadow as integer,iLight as integer)
   if Lighting_ShadowPoint[iShadow].Face1Update>0 or Lighting_ShadowPoint[iShadow].Face2Update>0 or Lighting_ShadowPoint[iShadow].Face3Update>0 or Lighting_ShadowPoint[iShadow].Face4Update>0 or Lighting_ShadowPoint[iShadow].Face5Update>0 or Lighting_ShadowPoint[iShadow].Face6Update>0
      SetCameraPosition(1,Lighting_Lights[iLight].Position.x,Lighting_Lights[iLight].Position.y,Lighting_Lights[iLight].Position.z)
      SetCameraRange(1,1,Lighting_Lights[iLight].Range)
      SetCameraFov(1,90) 
      SetCameraAspect(1,1)
      for f=1 to 6
         if f=1 then tFaceUpdate=Lighting_ShadowPoint[iShadow].Face1Update
         if f=2 then tFaceUpdate=Lighting_ShadowPoint[iShadow].Face2Update
         if f=3 then tFaceUpdate=Lighting_ShadowPoint[iShadow].Face3Update
         if f=4 then tFaceUpdate=Lighting_ShadowPoint[iShadow].Face4Update
         if f=5 then tFaceUpdate=Lighting_ShadowPoint[iShadow].Face5Update
         if f=6 then tFaceUpdate=Lighting_ShadowPoint[iShadow].Face6Update
         if tFaceUpdate=1
            if f=1 then SetCameraRotation(1,0,90,0)
            if f=2 then SetCameraRotation(1,0,-90,0)
            if f=3 then SetCameraRotation(1,-90,0,0)
            if f=4 then SetCameraRotation(1,90,0,0)
            if f=5 then SetCameraRotation(1,0,0,0)
            if f=6 then SetCameraRotation(1,0,180,0)
            SetRenderToImage(0,Lighting_ShadowPointImage[iShadow,f])
            ClearScreen()
            render3d()
         endif
      next f
      Lighting_ShadowPoint[iShadow].Face1Update=0:Lighting_ShadowPoint[iShadow].Face2Update=0:Lighting_ShadowPoint[iShadow].Face3Update=0
      Lighting_ShadowPoint[iShadow].Face4Update=0:Lighting_ShadowPoint[iShadow].Face5Update=0:Lighting_ShadowPoint[iShadow].Face6Update=0
      Lighting_Lights[iLight].ShadowUpdateTime=Lighting_Lights[iLight].Dist/(1+(Lighting_Lights[iLight].Offset.w*0.01))
   endif
endfunction

`--------------
` Render Spot Light Shadowmaps
`--------------
function ShadowMapRenderSpot(iShadow as integer,iLight as integer)
   if Lighting_ShadowSpot[iShadow].Face1Update>0
      FOV#=htan(((Lighting_Lights[iLight].Cone.z/100)^0.5)*32.5)*325
      SetCameraPosition(1,Lighting_Lights[iLight].Position.x,Lighting_Lights[iLight].Position.y,Lighting_Lights[iLight].Position.z)
      SetCameraRange(1,1,Lighting_Lights[iLight].Range)
      SetCameraFov(1,FOV#) 
      SetCameraAspect(1,1)
      SetCameraRotation(1,Lighting_Lights[iLight].Angle.x,Lighting_Lights[iLight].Angle.y,Lighting_Lights[iLight].Angle.z)
      SetRenderToImage(0,Lighting_ShadowSpotImage[iShadow])
      ClearScreen()
      render3d()
      Set_Vector4(1,0,0,0,0)
      if Lighting_Lights[iLight].Masked=4 then Set_Vector4(1,1,0,0,0)
      if Lighting_Lights[iLight].Masked=1 or Lighting_Lights[iLight].Masked=5 then Set_Vector4(1,0,1,0,0)
      if Lighting_Lights[iLight].Masked=2 or Lighting_Lights[iLight].Masked=6 then Set_Vector4(1,0,0,1,0)
      if Lighting_Lights[iLight].Masked=3 or Lighting_Lights[iLight].Masked=7 then Set_Vector4(1,0,0,0,1)
      SetIdentity_Matrix4(1)
      Matrix4Float[1,1].x=Lighting_Lights[iLight].MatAng1.x : Matrix4Float[1,1].y=Lighting_Lights[iLight].MatAng1.y : Matrix4Float[1,1].z=Lighting_Lights[iLight].MatAng1.z  
      Matrix4Float[1,2].x=Lighting_Lights[iLight].MatAng2.x : Matrix4Float[1,2].y=Lighting_Lights[iLight].MatAng2.y : Matrix4Float[1,2].z=Lighting_Lights[iLight].MatAng2.z 
      Matrix4Float[1,3].x=Lighting_Lights[iLight].MatAng3.x : Matrix4Float[1,3].y=Lighting_Lights[iLight].MatAng3.y : Matrix4Float[1,3].z=Lighting_Lights[iLight].MatAng3.z 
      Translate_Matrix4(2,-Lighting_Lights[iLight].Position.x,-Lighting_Lights[iLight].Position.y,-Lighting_Lights[iLight].Position.z)
      Multiply_Matrix4(1,2,1)
      FOV#=1.0/tan(FOV#/2.0)
      Fill_Matrix4(2,0)
      Matrix4Float[2,1].x=FOV#
      Matrix4Float[2,2].y=-FOV#
      Matrix4Float[2,3].z=-1.0/(Lighting_Lights[iLight].Range-1.0)
      Matrix4Float[2,3].w=1.0
      Matrix4Float[2,4].z=(Lighting_Lights[iLight].Range-1.0)/Lighting_Lights[iLight].Range
      Multiply_Matrix4(3,1,2)
      GetViewProjectFrustum(iShadow,3)
      Lighting_ShadowSpot[iShadow].Face1Update=0
      Lighting_Lights[iLight].ShadowUpdateTime=Lighting_Lights[iLight].Dist/(1+(Lighting_Lights[iLight].Offset.w*0.01))
    endif
endfunction





